# AI dla gier wideo — zostań mistrzem Snake’a
# Testowanie AI

# Importowanie bibliotek
from environment import Environment
from brain import Brain
import numpy as np

# Definiowanie parametrów
nLastStates = 4
filepathToOpen = 'model.h5'
slowdown = 75

# Tworzenie obiektów Environment oraz Brain
env = Environment(slowdown)
brain = Brain((env.nRows, env.nColumns, nLastStates))
model = brain.loadModel(filepathToOpen)

# Utworzenie funkcji, która zresetuje stan gry
def resetStates():
    currentState = np.zeros((1, env.nRows, env.nColumns, nLastStates))
    
    for i in range(nLastStates):
        currentState[:,:,:,i] = env.screenMap
   
    return currentState, currentState

# Uruchomienie głównej pętli
while True:
    # Resetowanie gry i stanów gry
    env.reset()
    currentState, nextState = resetStates()
    gameOver = False
    
    # Gra
    while not gameOver: 
        
        # Wybór akcji do wykonania
        qvalues = model.predict(currentState)[0]
        action = np.argmax(qvalues)
        
        # Aktualizacja środowiska
        state, _, gameOver = env.step(action)
        
        # Dodanie nowej klatki gry do następnego stanu i usunięcie najstarszej
        state = np.reshape(state, (1, env.nRows, env.nColumns, 1))
        nextState = np.append(nextState, state, axis = 3)
        nextState = np.delete(nextState, 0, axis = 3)
        
        # Aktualizacja obecnego stanu
        currentState = nextState
